import Utilities.gui_creator as gc
import Utilities.mccdaq_operations as mo
import threading
#import time

board_num, channel = 0, 0
ai_range = mo.chan_range('bipolar_10')


root = gc.create_window(title='DC Voltmeter',
                        size='250x100')

lbl_2 = gc.create_indicator(root,
                            label_1='Voltage Reading (V)')

def acquire_sample():

    while btn.cget('text') == 'Stop':

        float_data = mo.read_sample(board_num, channel,
                                    ai_range)
        string_data = f'{float_data:.3f}'

        lbl_2.config(text=string_data)

#        time.sleep(0.1)

    return

def toggle():

    if btn.cget('text') == 'Start':
        btn.config(text='Stop')
    elif btn.cget('text') == 'Stop':
        btn.config(text='Start')

    t = threading.Thread(target=acquire_sample)
    t.start()

    return

btn = gc.action_button(root, label='Start', action=toggle)

root.mainloop()

